package com.qboxus.tictic.activitesfragments.shoping.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;

import com.qboxus.tictic.activitesfragments.location.DeliveryAddress;
import com.qboxus.tictic.models.UserModel;

public class OrderHistoryModel implements Parcelable {
    @SerializedName("Order")
    public Order order;

    @SerializedName("DeliveryAddress")
    public DeliveryAddress deliveryAddress;

    @SerializedName("User")
    public UserModel user;


    @SerializedName("Store")
    public UserModel store;

    @SerializedName("OrderProduct")
    public ArrayList<OrderProduct> orderProduct;

    protected OrderHistoryModel(Parcel in) {
        order = in.readParcelable(Order.class.getClassLoader());
        deliveryAddress = in.readParcelable(DeliveryAddress.class.getClassLoader());
        user = in.readParcelable(UserModel.class.getClassLoader());
        store = in.readParcelable(UserModel.class.getClassLoader());
        orderProduct = in.createTypedArrayList(OrderProduct.CREATOR);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(order, flags);
        dest.writeParcelable(deliveryAddress, flags);
        dest.writeParcelable(user, flags);
        dest.writeParcelable(store, flags);
        dest.writeTypedList(orderProduct);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<OrderHistoryModel> CREATOR = new Creator<OrderHistoryModel>() {
        @Override
        public OrderHistoryModel createFromParcel(Parcel in) {
            return new OrderHistoryModel(in);
        }

        @Override
        public OrderHistoryModel[] newArray(int size) {
            return new OrderHistoryModel[size];
        }
    };
}
